/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.UGen;

public class MoogFilter
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(this, UGen.InputType.AUDIO);
    public UGen.UGenInput frequency = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    public UGen.UGenInput resonance = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    private float[][] coeff;

    public MoogFilter(float f, float f2) {
        this.frequency.setLastValue(f);
        this.resonance.setLastValue(this.constrain(f2, 0.0f, 1.0f));
    }

    @Override
    public void setAudioChannelCount(int n) {
        super.setAudioChannelCount(n);
        if (this.coeff == null || this.coeff.length != n) {
            this.coeff = new float[n][5];
        }
    }

    @Override
    protected void uGenerate(float[] fArray) {
        float f = this.frequency.getLastValue() / (this.sampleRate() * 0.5f);
        float f2 = this.constrain(this.resonance.getLastValue(), 0.0f, 1.0f);
        float f3 = 1.0f - f;
        float f4 = f + 0.8f * f * f3;
        float f5 = f4 + f4 - 1.0f;
        f3 = f2 * (1.0f + 0.5f * f3 * (1.0f - f3 + 5.6f * f3 * f3));
        float[] fArray2 = this.audio.getLastValues();
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray3 = this.coeff[i];
            float f6 = fArray2[i];
            float f7 = fArray3[1];
            fArray3[1] = ((f6 -= f3 * fArray3[4]) + fArray3[0]) * f4 - fArray3[1] * f5;
            float f8 = fArray3[2];
            fArray3[2] = (fArray3[1] + f7) * f4 - fArray3[2] * f5;
            f7 = fArray3[3];
            fArray3[3] = (fArray3[2] + f8) * f4 - fArray3[3] * f5;
            fArray3[4] = (fArray3[3] + f7) * f4 - fArray3[4] * f5;
            fArray3[4] = fArray3[4] - fArray3[4] * fArray3[4] * fArray3[4] * 0.166667f;
            fArray3[0] = f6;
            fArray[i] = fArray3[4];
        }
    }

    private float constrain(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }
}

